const express = require("express");
const fs = require("fs");
const app = express();

app.use(express.json());

const DATA_FILE = "./employees.json";

// Helper function to read file
function readEmployees() {
    const data = fs.readFileSync(DATA_FILE);
    return JSON.parse(data);
}

// Helper function to write file
function writeEmployees(data) {
    fs.writeFileSync(DATA_FILE, JSON.stringify(data, null, 2));
}

// POST /employees - Add employee
app.post("/employees", (req, res) => {
    const employees = readEmployees();

    const newEmployee = {
        id: Date.now().toString(),
        ...req.body
    };

    employees.push(newEmployee);
    writeEmployees(employees);

    res.status(201).json({ message: "Employee added", employee: newEmployee });
});

// GET /employees - Get all employees
app.get("/employees", (req, res) => {
    const employees = readEmployees();
    res.json(employees);
});

// GET /employees/:id - Get employee by ID
app.get("/employees/:id", (req, res) => {
    const employees = readEmployees();
    const employee = employees.find(emp => emp.id === req.params.id);

    if (!employee) {
        return res.status(404).json({ message: "Employee not found" });
    }

    res.json(employee);
});

// PUT /employees/:id - Update employee
app.put("/employees/:id", (req, res) => {
    const employees = readEmployees();
    const index = employees.findIndex(emp => emp.id === req.params.id);

    if (index === -1) {
        return res.status(404).json({ message: "Employee not found" });
    }

    employees[index] = { ...employees[index], ...req.body };
    writeEmployees(employees);

    res.json({ message: "Employee updated", employee: employees[index] });
});

// DELETE /employees/:id - Delete employee
app.delete("/employees/:id", (req, res) => {
    let employees = readEmployees();
    const filtered = employees.filter(emp => emp.id !== req.params.id);

    if (filtered.length === employees.length) {
        return res.status(404).json({ message: "Employee not found" });
    }

    writeEmployees(filtered);

    res.json({ message: "Employee deleted" });
});

// Start server
const PORT = process.env.PORT || 3000;
app.listen(PORT, () => console.log("Server running on port " + PORT));
